#include "EasyPOD.H"


//----- Timer0 -----//
extern BIT OutFlag;
extern BYTE PinStatus[5];
extern void Initial_Timer0( void );


void USB_Event( void );

void main( void )
  { Initial();                                   // Do not remove
    
    Initial_Timer0();
    
    while(1)
      { if ( InFlag )                            // Data size of "InLen" is already 
          { // To do..                           // in the "InBuffer[]"
            if ( InBuffer[0] == 0 )              // P0
              P0 = InBuffer[1];
            if ( InBuffer[0] == 1 )              // P1
              P1 = InBuffer[1];
            if ( InBuffer[0] == 2 )              // P2
              P2 = InBuffer[1];
            if ( InBuffer[0] == 3 )              // P3
              P3 = InBuffer[1];
            if ( InBuffer[0] == 4 )              // P4
              P4 = InBuffer[1];
            
            USB_Read_Data_Complete();            // Do not remove
          }
        
        if ( OutFlag )
          { USB_Send_Data_To_PC( 5 , PinStatus );
            OutFlag = CLR;
          }
        
        USB_Event();                             // Check USB power event
      }   
  }


void USB_Event( void )                           // Do not remove
  { if ( UsbEvent.Suspend == SET )               // Power down event from HOST
      { UsbEvent.Suspend = CLR;
        // To do..
        PCON |= 0x02;                            // MCU will into PowerDown mode
        UsbEvent.WakeUp = SET;
      }
    if ( UsbEvent.WakeUp == SET )                // MCU wakeup already
      { UsbEvent.WakeUp = CLR;
      	// To do..
      }
    if ( UsbEvent.Reset == SET )                 // Reset event from HOST
      { UsbEvent.Reset = CLR;
        // To do..
      }
    if ( UsbEvent.EmuOK == SET )                 // USB enumeration OK
      { // To do..
      }
  }